<?php
require_once '../config/config.php';
require_once '../includes/SessionManager.php';

$sessionManager = new SessionManager();

if (!$sessionManager->isLoggedIn()) {
    header('Location: login.php');
    exit;
}

$user = $sessionManager->getCurrentUser();
$db = getDBConnection();

// Récupération des statistiques
$statsStmt = $db->query("
    SELECT 
        total_keys,
        active_keys,
        used_keys,
        revoked_keys,
        expired_keys,
        total_installations
    FROM view_keys_summary
");
$stats = $statsStmt->fetch();

// Récupération des activités récentes
$activityStmt = $db->query("
    SELECT activity_type, description, created_at 
    FROM view_recent_activity 
    ORDER BY created_at DESC 
    LIMIT 10
");
$recentActivities = $activityStmt->fetchAll();

// Récupération des clés expirant bientôt
$expiringStmt = $db->query("
    SELECT key_name, key_value, expires_at, client_name
    FROM installation_keys 
    WHERE status = 'active' AND expires_at <= DATE_ADD(CURDATE(), INTERVAL 7 DAY)
    ORDER BY expires_at ASC 
    LIMIT 5
");
$expiringKeys = $expiringStmt->fetchAll();
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Tableau de Bord - Pedazone Keys Manager</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/css/bootstrap.min.css" rel="stylesheet">
    <link href="https://cdnjs.cloudflare.com/ajax/libs/font-awesome/6.0.0/css/all.min.css" rel="stylesheet">
    <style>
        .stat-card {
            border-radius: 10px;
            border: none;
            box-shadow: 0 4px 6px rgba(0,0,0,0.1);
            transition: transform 0.3s;
        }
        .stat-card:hover {
            transform: translateY(-5px);
        }
        .bg-gradient-primary { background: linear-gradient(135deg, #667eea, #764ba2); }
        .bg-gradient-success { background: linear-gradient(135deg, #10b981, #059669); }
        .bg-gradient-warning { background: linear-gradient(135deg, #f59e0b, #d97706); }
        .bg-gradient-danger { background: linear-gradient(135deg, #ef4444, #dc2626); }
    </style>
</head>
<body>
    <?php 
    $pageTitle = "Tableau de Bord";
    include 'includes/header.php'; 
    ?>
    
    <div class="container-fluid mt-4">
        <div class="row">
            <?php include 'includes/sidebar.php'; ?>
            
            <main class="col-md-9 ms-sm-auto col-lg-10 px-md-4">
                <div class="d-flex justify-content-between align-items-center mb-4">
                    <h2>Tableau de Bord</h2>
                    <span class="text-muted">Bienvenue, <?php echo htmlspecialchars($user['full_name']); ?> !</span>
                </div>

                <!-- Cartes de statistiques -->
                <div class="row mb-4">
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card stat-card text-white bg-gradient-primary">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-white-50 small">Clés Actives</div>
                                        <div class="h2 mb-0"><?php echo $stats['active_keys']; ?></div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-key fa-2x text-white-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card stat-card text-white bg-gradient-success">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-white-50 small">Installations</div>
                                        <div class="h2 mb-0"><?php echo $stats['total_installations']; ?></div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-server fa-2x text-white-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card stat-card text-white bg-gradient-warning">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-white-50 small">Clés Utilisées</div>
                                        <div class="h2 mb-0"><?php echo $stats['used_keys']; ?></div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-check-circle fa-2x text-white-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                    
                    <div class="col-xl-3 col-md-6 mb-3">
                        <div class="card stat-card text-white bg-gradient-danger">
                            <div class="card-body">
                                <div class="d-flex justify-content-between">
                                    <div>
                                        <div class="text-white-50 small">Clés Expirées</div>
                                        <div class="h2 mb-0"><?php echo $stats['expired_keys']; ?></div>
                                    </div>
                                    <div class="align-self-center">
                                        <i class="fas fa-exclamation-triangle fa-2x text-white-50"></i>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>

                <div class="row">
                    <!-- Activités Récentes -->
                    <div class="col-lg-8 mb-4">
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-history me-2"></i>Activités Récentes
                                </h5>
                            </div>
                            <div class="card-body">
                                <div class="table-responsive">
                                    <table class="table table-hover">
                                        <thead>
                                            <tr>
                                                <th>Type</th>
                                                <th>Description</th>
                                                <th>Date</th>
                                            </tr>
                                        </thead>
                                        <tbody>
                                            <?php foreach ($recentActivities as $activity): ?>
                                            <tr>
                                                <td>
                                                    <?php 
                                                    $badgeClass = [
                                                        'key_created' => 'bg-primary',
                                                        'installation' => 'bg-success'
                                                    ][$activity['activity_type']] ?? 'bg-secondary';
                                                    ?>
                                                    <span class="badge <?php echo $badgeClass; ?>">
                                                        <?php echo ucfirst(str_replace('_', ' ', $activity['activity_type'])); ?>
                                                    </span>
                                                </td>
                                                <td><?php echo htmlspecialchars($activity['description']); ?></td>
                                                <td><?php echo date('d/m/Y H:i', strtotime($activity['created_at'])); ?></td>
                                            </tr>
                                            <?php endforeach; ?>
                                        </tbody>
                                    </table>
                                </div>
                            </div>
                        </div>
                    </div>

                    <!-- Clés Expirant Bientôt & Actions Rapides -->
                    <div class="col-lg-4 mb-4">
                        <!-- Clés Expirant Bientôt -->
                        <div class="card mb-4">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-clock me-2"></i>Clés Expirant Bientôt
                                </h5>
                            </div>
                            <div class="card-body">
                                <?php if (empty($expiringKeys)): ?>
                                    <p class="text-muted text-center">Aucune clé n'expire bientôt</p>
                                <?php else: ?>
                                    <?php foreach ($expiringKeys as $key): ?>
                                    <div class="alert alert-warning alert-dismissible fade show mb-2" role="alert">
                                        <small>
                                            <strong><?php echo htmlspecialchars($key['key_name']); ?></strong><br>
                                            <span class="text-muted">Expire le: <?php echo date('d/m/Y', strtotime($key['expires_at'])); ?></span>
                                        </small>
                                    </div>
                                    <?php endforeach; ?>
                                <?php endif; ?>
                            </div>
                        </div>

                        <!-- Actions Rapides -->
                        <div class="card">
                            <div class="card-header">
                                <h5 class="card-title mb-0">
                                    <i class="fas fa-bolt me-2"></i>Actions Rapides
                                </h5>
                            </div>
                            <div class="card-body">
                                <a href="keys.php?action=create" class="btn btn-primary w-100 mb-2">
                                    <i class="fas fa-plus me-2"></i>Nouvelle Clé
                                </a>
                                <a href="reports.php" class="btn btn-outline-secondary w-100">
                                    <i class="fas fa-download me-2"></i>Exporter Rapports
                                </a>
                            </div>
                        </div>
                    </div>
                </div>
            </main>
        </div>
    </div>

    <script src="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/js/bootstrap.bundle.min.js"></script>
</body>
</html>