<?php
require_once '../../config/config.php';
require_once '../../includes/SessionManager.php';

$sessionManager = new SessionManager();

if (!$sessionManager->isLoggedIn()) {
    header('Location: ../login.php');
    exit;
}

// Vérification des permissions si nécessaire
$currentPage = basename($_SERVER['PHP_SELF']);
$user = $sessionManager->getCurrentUser();

// Protection des pages réservées aux superadmins
$superadminPages = ['system-settings.php', 'user-management.php'];
if (in_array($currentPage, $superadminPages) && !$sessionManager->hasPermission('superadmin')) {
    header('Location: dashboard.php');
    exit;
}
?>