<?php
// Header commun pour toutes les pages
$user = $sessionManager->getCurrentUser();
?>
<nav class="navbar navbar-expand-lg navbar-light bg-white shadow-sm">
    <div class="container-fluid">
        <button class="navbar-toggler d-md-none" type="button" data-bs-toggle="collapse" data-bs-target="#sidebarMenu">
            <span class="navbar-toggler-icon"></span>
        </button>
        
        <div class="d-flex align-items-center">
            <h4 class="mb-0"><?php echo $pageTitle ?? 'Pedazone Keys Manager'; ?></h4>
        </div>
        
        <div class="d-flex align-items-center">
            <span class="me-3 text-muted d-none d-md-block">
                <i class="fas fa-user-circle me-1"></i>
                <?php echo htmlspecialchars($user['full_name']); ?>
                <small class="badge bg-secondary"><?php echo $user['role']; ?></small>
            </span>
            <div class="dropdown">
                <button class="btn btn-outline-secondary dropdown-toggle" type="button" data-bs-toggle="dropdown">
                    <i class="fas fa-cog"></i>
                </button>
                <ul class="dropdown-menu dropdown-menu-end">
                    <li><a class="dropdown-item" href="profile.php"><i class="fas fa-user me-2"></i>Profil</a></li>
                    <li><a class="dropdown-item" href="settings.php"><i class="fas fa-cogs me-2"></i>Paramètres</a></li>
                    <li><hr class="dropdown-divider"></li>
                    <li><a class="dropdown-item" href="logout.php"><i class="fas fa-sign-out-alt me-2"></i>Déconnexion</a></li>
                </ul>
            </div>
        </div>
    </div>
</nav>