<?php
// Sidebar commune pour toutes les pages
$currentPage = basename($_SERVER['PHP_SELF']);
?>
<nav class="col-md-3 col-lg-2 d-md-block sidebar collapse">
    <div class="position-sticky pt-3">
        <div class="text-center mb-4">
            <h4>🔐 Pedazone Keys</h4>
            <small class="text-white-50">Gestion des Clés</small>
        </div>
        
        <ul class="nav flex-column">
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'dashboard.php' ? 'active' : ''; ?>" href="dashboard.php">
                    <i class="fas fa-tachometer-alt"></i>
                    Tableau de Bord
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'keys.php' ? 'active' : ''; ?>" href="keys.php">
                    <i class="fas fa-key"></i>
                    Gestion des Clés
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'installations.php' ? 'active' : ''; ?>" href="installations.php">
                    <i class="fas fa-server"></i>
                    Installations
                </a>
            </li>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'reports.php' ? 'active' : ''; ?>" href="reports.php">
                    <i class="fas fa-chart-bar"></i>
                    Rapports
                </a>
            </li>
            <?php if ($user['role'] === 'superadmin'): ?>
            <li class="nav-item">
                <a class="nav-link <?php echo $currentPage === 'system-settings.php' ? 'active' : ''; ?>" href="system-settings.php">
                    <i class="fas fa-cog"></i>
                    Paramètres
                </a>
            </li>
            <?php endif; ?>
            <li class="nav-item">
                <a class="nav-link" href="logout.php">
                    <i class="fas fa-sign-out-alt"></i>
                    Déconnexion
                </a>
            </li>
        </ul>
    </div>
</nav>