<?php
require_once '../config/config.php';
require_once '../config/database.php';

// Script de test pour l'API de validation
class TestKeyValidation {
    private $apiUrl;
    
    public function __construct() {
        $this->apiUrl = APP_URL . '/api/validate-key.php';
    }
    
    public function testValidation() {
        echo "<h2>Test API Validation de Clés</h2>";
        
        // Test 1: Clé valide
        $this->testValidKey();
        
        // Test 2: Clé invalide
        $this->testInvalidKey();
        
        // Test 3: Clé expirée
        $this->testExpiredKey();
    }
    
    private function testValidKey() {
        echo "<h3>Test avec clé valide</h3>";
        
        $data = [
            'installation_key' => 'PEDAZONE-TEST-1234-5678',
            'domain' => 'test-universite.fr',
            'client_email' => 'admin@test-universite.fr',
            'action' => 'validate'
        ];
        
        $result = $this->makeApiRequest($data);
        $this->displayResult($result);
    }
    
    private function testInvalidKey() {
        echo "<h3>Test avec clé invalide</h3>";
        
        $data = [
            'installation_key' => 'INVALID-KEY-1234',
            'domain' => 'test-universite.fr',
            'client_email' => 'admin@test-universite.fr',
            'action' => 'validate'
        ];
        
        $result = $this->makeApiRequest($data);
        $this->displayResult($result);
    }
    
    private function testExpiredKey() {
        echo "<h3>Test avec clé expirée</h3>";
        
        // Créer une clé expirée pour le test
        $this->createExpiredKeyForTest();
        
        $data = [
            'installation_key' => 'PEDAZONE-EXPIRED-TEST',
            'domain' => 'test-universite.fr',
            'client_email' => 'admin@test-universite.fr',
            'action' => 'validate'
        ];
        
        $result = $this->makeApiRequest($data);
        $this->displayResult($result);
    }
    
    private function makeApiRequest($data) {
        $ch = curl_init();
        
        curl_setopt_array($ch, [
            CURLOPT_URL => $this->apiUrl,
            CURLOPT_POST => true,
            CURLOPT_POSTFIELDS => http_build_query($data),
            CURLOPT_RETURNTRANSFER => true,
            CURLOPT_SSL_VERIFYPEER => false,
            CURLOPT_TIMEOUT => 30
        ]);
        
        $response = curl_exec($ch);
        $httpCode = curl_getinfo($ch, CURLINFO_HTTP_CODE);
        curl_close($ch);
        
        return [
            'http_code' => $httpCode,
            'response' => json_decode($response, true),
            'raw_response' => $response
        ];
    }
    
    private function displayResult($result) {
        echo "<div style='border: 1px solid #ccc; padding: 10px; margin: 10px 0;'>";
        echo "<strong>Code HTTP:</strong> " . $result['http_code'] . "<br>";
        echo "<strong>Réponse:</strong><br>";
        echo "<pre>" . json_encode($result['response'], JSON_PRETTY_PRINT | JSON_UNESCAPED_UNICODE) . "</pre>";
        echo "</div>";
    }
    
    private function createExpiredKeyForTest() {
        // Cette méthode créerait une clé expirée pour les tests
        // Implémentation simplifiée pour l'exemple
    }
}

// Exécution du test si demandé
if (isset($_GET['test'])) {
    $tester = new TestKeyValidation();
    $tester->testValidation();
} else {
    echo "<p>Pour tester l'API, ajoutez <code>?test=1</code> à l'URL</p>";
}
?>