<?php
class DatabaseConfig {
    // Configuration de la base de données
    private $host = 'localhost';
    private $db_name = 'pedazone_keys_manager';
    private $username = 'root';
    private $password = '';
    private $charset = 'utf8mb4';
    
    public $connection;
    
    // Méthode de connexion
    public function getConnection() {
        $this->connection = null;
        
        try {
            $dsn = "mysql:host=" . $this->host . ";dbname=" . $this->db_name . ";charset=" . $this->charset;
            $this->connection = new PDO($dsn, $this->username, $this->password);
            $this->connection->setAttribute(PDO::ATTR_ERRMODE, PDO::ERRMODE_EXCEPTION);
            $this->connection->setAttribute(PDO::ATTR_DEFAULT_FETCH_MODE, PDO::FETCH_ASSOC);
            $this->connection->setAttribute(PDO::ATTR_EMULATE_PREPARES, false);
            
        } catch(PDOException $exception) {
            error_log("Erreur de connexion à la base de données: " . $exception->getMessage());
            throw new Exception("Impossible de se connecter à la base de données.");
        }
        
        return $this->connection;
    }
    
    // Méthode pour tester la connexion
    public function testConnection() {
        try {
            $conn = $this->getConnection();
            return [
                'success' => true,
                'message' => 'Connexion à la base de données réussie!',
                'database' => $this->db_name
            ];
        } catch (Exception $e) {
            return [
                'success' => false,
                'message' => $e->getMessage()
            ];
        }
    }
}

// Fonction utilitaire pour obtenir une connexion
function getDBConnection() {
    $database = new DatabaseConfig();
    return $database->getConnection();
}
?>