<?php
// =============================================
// INSTALLATION DU SYSTÈME DE GESTION DES CLÉS
// =============================================

define('KEYS_VERSION', '1.0.0');
define('LOCK_FILE', __DIR__ . '/install.lock');

// Vérifier si déjà installé
if (file_exists(LOCK_FILE)) {
    die('Système de clés déjà installé!');
}

$step = $_GET['step'] ?? 1;
$errors = [];
$success = '';

// Traitement du formulaire d'installation
if ($_SERVER['REQUEST_METHOD'] === 'POST') {
    $db_host = $_POST['db_host'] ?? 'localhost';
    $db_name = $_POST['db_name'] ?? 'pedazone_keys';
    $db_user = $_POST['db_user'] ?? '';
    $db_pass = $_POST['db_pass'] ?? '';
    
    // Test connexion BDD
    try {
        $dsn = "mysql:host=$db_host;charset=utf8mb4";
        $pdo = new PDO($dsn, $db_user, $db_pass, [
            PDO::ATTR_ERRMODE => PDO::ERRMODE_EXCEPTION
        ]);
        
        // Créer la base si elle n'existe pas
        $pdo->exec("CREATE DATABASE IF NOT EXISTS `$db_name` CHARACTER SET utf8mb4 COLLATE utf8mb4_unicode_ci");
        $pdo->exec("USE `$db_name`");
        
        // Exécuter le script SQL
        $sql = file_get_contents(__DIR__ . '/database/schema.sql');
        $pdo->exec($sql);
        
        // Créer le fichier de configuration
        $config_template = file_get_contents(__DIR__ . '/config/config.php.template');
        $config_content = str_replace(
            ['{{DB_HOST}}', '{{DB_NAME}}', '{{DB_USER}}', '{{DB_PASS}}'],
            [$db_host, $db_name, $db_user, $db_pass],
            $config_template
        );
        
        file_put_contents(__DIR__ . '/config/config.php', $config_content);
        
        // Créer le fichier de verrouillage
        file_put_contents(LOCK_FILE, "Installé le " . date('Y-m-d H:i:s'));
        
        $success = "Système de clés installé avec succès!";
        $step = 4; // Étape finale
        
    } catch (Exception $e) {
        $errors[] = "Erreur base de données: " . $e->getMessage();
    }
}
?>
<!DOCTYPE html>
<html lang="fr">
<head>
    <meta charset="UTF-8">
    <meta name="viewport" content="width=device-width, initial-scale=1.0">
    <title>Installation - Pedazone Keys Manager</title>
    <link href="https://cdnjs.cloudflare.com/ajax/libs/bootstrap/5.1.3/css/bootstrap.min.css" rel="stylesheet">
    <style>
        body { background: linear-gradient(135deg, #667eea 0%, #764ba2 100%); min-height: 100vh; }
        .install-container { max-width: 600px; margin: 50px auto; background: white; border-radius: 15px; box-shadow: 0 15px 35px rgba(0,0,0,0.1); }
    </style>
</head>
<body>
    <div class="install-container p-4">
        <div class="text-center mb-4">
            <h1>🔐 Pedazone Keys</h1>
            <p class="text-muted">Installation du système de gestion des clés</p>
        </div>
        
        <?php if ($errors): ?>
        <div class="alert alert-danger">
            <?php foreach ($errors as $error): ?>
            <div><?php echo $error; ?></div>
            <?php endforeach; ?>
        </div>
        <?php endif; ?>
        
        <?php if ($success): ?>
        <div class="alert alert-success">
            <?php echo $success; ?>
        </div>
        <?php endif; ?>
        
        <!-- Étape 1: Bienvenue -->
        <?php if ($step == 1): ?>
        <div class="text-center">
            <h3>Bienvenue</h3>
            <p>Ce système gère les clés d'installation pour la plateforme Pedazone.</p>
            <a href="?step=2" class="btn btn-primary">Commencer l'installation</a>
        </div>
        
        <!-- Étape 2: Prérequis -->
        <?php elseif ($step == 2): ?>
        <h3>Vérification des prérequis</h3>
        <ul class="list-group mb-3">
            <li class="list-group-item d-flex justify-content-between align-items-center">
                PHP 7.4+
                <span class="badge bg-<?php echo version_compare(PHP_VERSION, '7.4.0', '>=') ? 'success' : 'danger'; ?>">
                    <?php echo PHP_VERSION; ?>
                </span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                Extension PDO MySQL
                <span class="badge bg-<?php echo extension_loaded('pdo_mysql') ? 'success' : 'danger'; ?>">
                    <?php echo extension_loaded('pdo_mysql') ? 'OK' : 'Manquant'; ?>
                </span>
            </li>
            <li class="list-group-item d-flex justify-content-between align-items-center">
                Permissions d'écriture
                <span class="badge bg-<?php echo is_writable(__DIR__) ? 'success' : 'danger'; ?>">
                    <?php echo is_writable(__DIR__) ? 'OK' : 'Problème'; ?>
                </span>
            </li>
        </ul>
        <a href="?step=3" class="btn btn-primary">Continuer</a>
        
        <!-- Étape 3: Configuration BDD -->
        <?php elseif ($step == 3): ?>
        <h3>Configuration Base de Données</h3>
        <form method="POST">
            <div class="mb-3">
                <label class="form-label">Hôte MySQL</label>
                <input type="text" name="db_host" value="localhost" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Nom de la base</label>
                <input type="text" name="db_name" value="pedazone_keys" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Utilisateur MySQL</label>
                <input type="text" name="db_user" class="form-control" required>
            </div>
            <div class="mb-3">
                <label class="form-label">Mot de passe MySQL</label>
                <input type="password" name="db_pass" class="form-control">
            </div>
            <button type="submit" class="btn btn-primary">Installer</button>
        </form>
        
        <!-- Étape 4: Terminé -->
        <?php elseif ($step == 4): ?>
        <div class="text-center">
            <h3 class="text-success">✅ Installation Terminée!</h3>
            <p>Le système de gestion des clés est maintenant opérationnel.</p>
            <div class="alert alert-info">
                <strong>URLs importantes:</strong><br>
                - <a href="admin/dashboard.php" target="_blank">Tableau de bord admin</a><br>
                - <a href="api/validate-key.php" target="_blank">API de validation</a>
            </div>
            <a href="admin/dashboard.php" class="btn btn-success">Accéder au Tableau de Bord</a>
        </div>
        <?php endif; ?>
    </div>
</body>
</html>